--> pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO


CREATE TABLE T_avion_avi
(avi_immat VARCHAR(6), avi_type CHAR(4), avi_hvol DECIMAL(7,2), cmp_comp VARCHAR(4));

CREATE TABLE T_compagnie_cmp
(cmp_comp VARCHAR(4), cmp_pays CHAR(3), cmp_nom VARCHAR(15),
 CONSTRAINT pk_compagnie PRIMARY KEY(cmp_comp));
GO

CREATE TABLE T_pilote_pil
(pil_brevet VARCHAR(6), pil_prenom VARCHAR(15), pil_nom VARCHAR(15), 
 pil_hvol DECIMAL(7,2), cmp_comp VARCHAR(4), pil_chef VARCHAR(6),
 CONSTRAINT pk_pilote PRIMARY KEY(pil_brevet),
 CONSTRAINT fk_pil_cmp FOREIGN KEY(cmp_comp) REFERENCES T_compagnie_cmp(cmp_comp),
 CONSTRAINT fk_pil_chef_pil FOREIGN KEY(pil_chef) REFERENCES T_pilote_pil(pil_brevet));
GO

CREATE TABLE T_qualifs_qlf
(pil_brevet VARCHAR(6), qlf_avi CHAR(4), qlf_valide DATE,
 CONSTRAINT fk_qlf_pil FOREIGN KEY(pil_brevet) REFERENCES T_pilote_pil(pil_brevet));
GO

INSERT INTO T_compagnie_cmp VALUES ('AF', 'fr', 'Air France');
INSERT INTO T_compagnie_cmp VALUES ('SING','sn', 'Singapore AL');
INSERT INTO T_compagnie_cmp VALUES ('CAST', 'fr', 'Castanet AL');


INSERT INTO T_pilote_pil VALUES ('PL-4', 'Henri','Alqui', 3400, 'AF', NULL);
INSERT INTO T_pilote_pil VALUES ('PL-1', 'Pierre','Lamothe', 450, 'AF','PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-2', 'Didier','Linxe', 900, 'AF','PL-4');
INSERT INTO T_pilote_pil VALUES ('PL-3', 'Michel','Castaings', 1000, 'SING', NULL);
INSERT INTO T_pilote_pil VALUES ('PL-5', 'Pascal','Larrazet', 1500,NULL,NULL);


INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A320','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-4', 'A340','20150624');
INSERT INTO T_qualifs_qlf VALUES ('PL-2', 'A320','20160404');
INSERT INTO T_qualifs_qlf VALUES ('PL-3', 'A330','20160513');

INSERT INTO T_avion_avi VALUES ('F-HVFR', 'A320', 1000, 'AF');
INSERT INTO T_avion_avi VALUES ('F-HRXM', 'A330', 1500, 'AF');
INSERT INTO T_avion_avi VALUES ('G-YGTR', 'A320', 550, 'SING');
INSERT INTO T_avion_avi VALUES ('N-345R', 'A340', 1800, 'SING');
INSERT INTO T_avion_avi VALUES ('F-GADE', 'A340', 200, 'AF');
INSERT INTO T_avion_avi VALUES ('F-HYZE', 'A330', 100, 'AF');



SELECT pil_brevet, pil_prenom, pil_nom
FROM   T_pilote_pil 
WHERE  cmp_comp =
   (SELECT cmp_comp
    FROM   T_compagnie_cmp
    WHERE  cmp_nom = 'Air France')
AND pil_hvol > 500;

SELECT pil_brevet,
       pil_nom, pil_hvol
FROM   T_pilote_pil
WHERE pil_hvol > 
    (SELECT pil_hvol 
     FROM T_pilote_pil WHERE pil_brevet = 'PL-2');

-- multi-lignes

SELECT  cmp_nom, cmp_pays
FROM    T_compagnie_cmp
WHERE   cmp_comp  IN
(SELECT  cmp_comp FROM T_pilote_pil
WHERE   pil_hvol > 950);

SELECT SUM(pil_hvol) AS "Total"
FROM   T_pilote_pil
WHERE  pil_chef IN 
(SELECT pil_brevet
 FROM   T_pilote_pil 
 WHERE  cmp_comp = 
 (SELECT cmp_comp
  FROM   T_compagnie_cmp
  WHERE  cmp_nom = 'Air France'));

SELECT   cmp_nom, cmp_pays
FROM     T_compagnie_cmp
WHERE    cmp_comp IN (SELECT cmp_comp FROM T_pilote_pil WHERE cmp_comp IS NOT NULL);

-- false retourn car un NULL...

SELECT   cmp_nom, cmp_pays
FROM     T_compagnie_cmp
WHERE    cmp_comp NOT IN (SELECT cmp_comp FROM T_pilote_pil);

SELECT   cmp_nom, cmp_pays
FROM     T_compagnie_cmp
WHERE    cmp_comp NOT IN (SELECT cmp_comp FROM T_pilote_pil WHERE cmp_comp IS NOT NULL);


-- ANY et ALL

SELECT avi_immat, avi_type, avi_hvol
FROM   T_avion_avi 
WHERE  avi_hvol <  ANY (SELECT avi_hvol FROM T_avion_avi WHERE avi_type='A320');

SELECT  avi_immat, avi_type, avi_hvol, cmp_comp
FROM    T_avion_avi 
WHERE   avi_hvol > ANY (SELECT avi_hvol FROM T_avion_avi WHERE cmp_comp= 'SING');

SELECT  avi_immat, avi_type, avi_hvol
FROM    T_avion_avi 
WHERE   avi_hvol < ALL (SELECT avi_hvol FROM T_avion_avi WHERE avi_type='A320');


SELECT  avi_immat, avi_type, avi_hvol, cmp_comp
FROM    T_avion_avi 
WHERE avi_hvol > ALL (SELECT avi_hvol FROM T_avion_avi WHERE cmp_comp= 'AF');

-- sous requete clause FROM


SELECT ta.cmp_comp AS "compagnie",
       CAST((CAST(ta.nbcomp AS REAL)/CAST(tb.total AS REAL))*100 
	   AS DECIMAL(4,2)) AS "% avion"
FROM   (SELECT cmp_comp, COUNT(*) nbcomp
        FROM T_avion_avi GROUP BY cmp_comp)     ta,
       (SELECT COUNT(*) total FROM T_avion_avi) tb;

-- synchronis

SELECT t1.avi_immat, t1.avi_type, t1.avi_hvol
FROM   T_avion_avi t1
WHERE  t1.avi_hvol >
       (SELECT AVG(t2.avi_hvol) FROM T_avion_avi t2
        WHERE  t2.cmp_comp = t1.cmp_comp);

-- update synchronis

ALTER TABLE T_compagnie_cmp 
ADD cmp_nb_avi SMALLINT;
GO

WITH t1 (cmp_comp, cmp_nb_avi) AS 
    (SELECT cmp_comp, cmp_nb_avi
      FROM   T_compagnie_cmp)
UPDATE t1 
SET    t1.cmp_nb_avi = 
       (SELECT COUNT(t2.avi_immat) FROM T_avion_avi t2
        WHERE  t2.cmp_comp = t1.cmp_comp);



IF OBJECT_ID('dbo.T_qualifs_qlf','U') IS NOT NULL
   DROP TABLE dbo.T_qualifs_qlf;
GO
IF OBJECT_ID('dbo.T_pilote_pil','U') IS NOT NULL
   DROP TABLE dbo.T_pilote_pil;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO



